### Alternative synergy

#Set working directory----
setwd('~/Documents/')

#Import necessary packages----
library(ggplot2)
library(dplyr)
library(readxl)
library(ggsignif)
library(patchwork)

#Import your dataset----
data <- read_xlsx('Synergy_Calculations_Variant.xlsx', sheet = 'Bliss_Trehalose')
#Change the factor order
data$Protein <- factor(data$Protein,levels = c('AtLEA3-3',
                                               'AavLEA1',
                                               'HeLEA68614',
                                               'AvLEA1C',
                                               'AtLEA4-2',
                                               'CAHS D',
                                               'BSA'))

#####make plot----
#create ggplot Environment----
Bliss_Trehalose <-ggplot(data = data, aes(x = Protein, y = Protection, fill = interaction(Protein, Measurement)))+
  #Make stacked bar graph---- 
##Make bottom layer first 
geom_col(
  position = position_dodge(width = .9), 
  color = 'black')+
  ##Make top layer w/ alpha adjustment
  #Set y-axis scale
  scale_y_continuous(name = '%Protection',
                     breaks = seq(0,100,20),
                     limits = c(0,100))+  
  #Set graph labels
  labs(x = '',
       y = '%Protection',
       title = 'Trehalose: FL Protein (Bliss Method)')+
  #Make Black and white theme
  theme_bw()+
  #Adjust graph settings
  theme(
    plot.title = element_text(hjust = 0.05, size = 8, vjust = -8),
    axis.title = element_text(size =6),
    axis.text = element_text(size =6),
    legend.text=element_text(size=14), 
    legend.position = 'none', aspect.ratio = .5,
    panel.border = element_rect(colour = "black", fill=NA, size=1))+
  #add error bars based on standard deviation
  geom_errorbar(aes(ymin = Protection - Stdev, ymax = Protection + Stdev), width = .2, position = position_dodge(.9))+
  #custom assignment of bar color----
scale_fill_manual(values = c('skyblue1', 'seagreen1', 'mediumpurple1',  'yellow1', 'coral1','lightblue1', 'thistle1',
                             'skyblue3',   'seagreen3', 'mediumpurple3', 'yellow3', 'coral3', 'lightblue3', 'thistle3'))+
  #add significane values
  geom_signif(
    y_position = c(63,  61, 63,63, 51,90,58),
    xmin = c(.75, 1.75, 2.75, 3.75,4.75,5.75, 6.75),
    xmax = c(1.25, 2.25, 3.25, 4.25, 5.25, 6.25, 7.25),
    annotation = c("***", "***", "***",'ns',"*", "***", "ns"),
    tip_length = 0, color = "black")

#Import your dataset----
data <- read_xlsx('Synergy_Calculations_Variant.xlsx', sheet = 'Bliss_Sucrose')
#Change the factor order
data$Protein <- factor(data$Protein,levels = c('AtLEA3-3',
                                               'AavLEA1',
                                               'HeLEA68614',
                                               'AvLEA1C',
                                               'AtLEA4-2',
                                               'CAHS D',
                                               'BSA'))

#####make plot----
#create ggplot Environment----
Bliss_Sucrose<-ggplot(data = data, aes(x = Protein, y = Protection, fill = interaction(Protein, Measurement)))+
  #Make stacked bar graph---- 
##Make bottom layer first 
geom_col(
  position = position_dodge(width = .9), 
  color = 'black')+
  ##Make top layer w/ alpha adjustment
  #Set y-axis scale
  scale_y_continuous(name = '%Protection',
                     breaks = seq(0,100,20),
                     limits = c(0,100))+  
  #Set graph labels
  labs(x = '',
       y = '%Protection',
       title = 'Sucrose: FL Protein (Bliss Method)')+
  #Make Black and white theme
  theme_bw()+
  #Adjust graph settings
  theme(
    plot.title = element_text(hjust = 0.05, size = 8, vjust = -8),
    axis.title = element_text(size =6),
    axis.text = element_text(size =6),
    legend.text=element_text(size=14), 
    legend.position = 'none', aspect.ratio = .5,
    panel.border = element_rect(colour = "black", fill=NA, size=1))+
  #add error bars based on standard deviation
  geom_errorbar(aes(ymin = Protection - Stdev, ymax = Protection + Stdev), width = .2, position = position_dodge(.9))+
  #custom assignment of bar color----
scale_fill_manual(values = c('skyblue1', 'seagreen1', 'mediumpurple1',  'yellow1', 'coral1','lightblue1', 'thistle1',
                             'skyblue3',   'seagreen3', 'mediumpurple3', 'yellow3', 'coral3', 'lightblue3', 'thistle3'))+
  #add significane values
  geom_signif(
    y_position = c(63,  48, 48,60, 71,70,52),
    xmin = c(.75, 1.75, 2.75, 3.75,4.75,5.75, 6.75),
    xmax = c(1.25, 2.25, 3.25, 4.25, 5.25, 6.25, 7.25),
    annotation = c("***", "*", "*",'*',"**", "***", "ns"),
    tip_length = 0, color = "black")

Bliss_Trehalose + Bliss_Sucrose + Kapp_Trehalose + Kapp_Sucrose + plot_layout(ncol = 2)


### 2C

#Set working directory----
setwd('~/Desktop/')

#Import necessary packages----
library(ggplot2)
library(dplyr)
library(readxl)
library(ggsignif)

#Import your dataset----
data <- read_xlsx('Bliss_new.xlsx')
#Change the factor order
data$prot <- factor(data$prot,levels = c('AtLEA3-3',
                                         'AavLEA1',
                                         'HeLEA68614',
                                         'AvLEA1C',
                                         'AtLEA4-2',
                                         'CAHS D',
                                         'BSA'))
#build ggplot environment
ggplot(data = data, aes(x = `%synergy_tre`, y = `%synergy_suc`, fill = prot))+
  geom_point(size = 6.5, shape = 21, color = 'black')+
  theme_bw()+
  theme(panel.grid = element_blank(),
        plot.title = element_text(hjust = 0.05, size = 14, vjust = -8),
        axis.title = element_text(size =14),
        axis.text.y = element_text(size =12),
        axis.text.x = element_text(size =12),
        legend.text=element_text(size=14), 
        legend.position = 'none', aspect.ratio = 1,
        panel.border = element_rect(colour = "black", fill=NA, size=1))+
  xlim(0,1.85)+
  ylim(0,1.85)+
  scale_color_manual(values = c(
    'skyblue3', 'seagreen3', 'mediumpurple3', 'yellow3', 'coral3', 'azure4', 'thistle3'))+
  geom_abline(linetype = 'dashed',
              linewidth = 1)+
  geom_errorbar(aes(ymin = `%synergy_suc` - `%synergy_suc_err`,
                    ymax = `%synergy_suc` + `%synergy_suc_err`),
                width = .075, position = position_dodge(.9))+
  geom_errorbarh(aes(xmin = `%synergy_tre` - `%synergy_tre_err`,
                     xmax = `%synergy_tre` + `%synergy_tre_err`),
                 height = .075, position = position_dodge(.9))+
  labs(
    x = 'Synergy with Trehalose',
    y = 'Synergy with Sucrose'
  )


### 2F

#Set working directory----
setwd('~/Downloads/')

#Import necessary packages----
library(ggplot2)
library(dplyr)
library(readxl)
library(ggsignif)

#Import your dataset----
data <- read_xlsx('Kapp.xlsx')
#Change the factor order
data$prot <- factor(data$prot,levels = c('AtLEA3-3',
                                         'AavLEA1',
                                         'HeLEA68614',
                                         'AvLEA1C',
                                         'AtLEA4-2',
                                         'CAHS D',
                                         'BSA'))
#build ggplot environment
ggplot(data = data, aes(x = `Kapp_tre`, y = `Kapp_suc`, fill = prot))+
  geom_point(size = 6.5, shape = 21, color = 'black')+
  theme_bw()+
  theme(panel.grid = element_blank(),
        plot.title = element_text(hjust = 0.05, size = 14, vjust = -8),
        axis.title = element_text(size =14),
        axis.text.y = element_text(size =12),
        axis.text.x = element_text(size =12),
        legend.text=element_text(size=14), 
        legend.position = 'none', aspect.ratio = 1,
        panel.border = element_rect(colour = "black", fill=NA, size=1))+
  xlim(-0.5,6)+
  ylim(-0.5,6)+
  scale_color_manual(values = c(
    'skyblue3', 'seagreen3', 'mediumpurple3', 'yellow3', 'coral3', 'azure4', 'thistle3'))+
  geom_abline(linetype = 'dashed',
              linewidth = 1)+
  geom_errorbar(aes(ymin = `Kapp_suc` - `Kapp_suc_err`,
                    ymax = `Kapp_suc` + `Kapp_suc_err`),
                width = .075, position = position_dodge(.9))+
  geom_errorbarh(aes(xmin = `Kapp_tre` - `Kapp_tre_err`,
                     xmax = `Kapp_tre` + `Kapp_tre_err`),
                 height = .075, position = position_dodge(.9))+
  labs(
    x = 'Synergy with Trehalose',
    y = 'Synergy with Sucrose'
  )

